(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    107006,       2520]
NotebookOptionsPosition[    105112,       2456]
NotebookOutlinePosition[    105526,       2474]
CellTagsIndexPosition[    105483,       2471]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
CallabUtil v. 0.99.1 October 2008
developed at the Institute of Robotics and Mechatronics of the German \
Aerospace Center (DLR), Oberpfaffenhofen (Germany) by Wolfgang Sepp.
Contains
- i/o functions reading CalDe/CalLab files
- projection functions, distortion function, and undistortion function for \
3rd and 5th order radial distortion.

This notebook is distributed in the hope that it will be useful, but WITHOUT \
ANY WARRANTY. You are free to use, modify, and redistribute this software as \
long as the credits to original authors and the license terms are made clear \
to the user.\
\>", "Text",
 CellChangeTimes->{{3.433594456219751*^9, 3.433594472507037*^9}, {
  3.433594575012021*^9, 3.43359477630586*^9}, {3.433595316350871*^9, 
  3.433595324149904*^9}, {3.433595631071019*^9, 3.433595643487413*^9}, {
  3.433597039154669*^9, 3.433597068723264*^9}, {3.433597122793122*^9, 
  3.43359714699342*^9}, {3.433597186900714*^9, 3.43359721677456*^9}, {
  3.433597255665635*^9, 3.433597257449374*^9}, {3.433597770667074*^9, 
  3.433597772890825*^9}, {3.433751254133556*^9, 3.433751288987609*^9}}],

Cell[CellGroupData[{

Cell["I/O Functions", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.433593179850067*^9, 3.43359318073759*^9}, {
  3.433595700820775*^9, 3.4335957029325*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ImportPts", "::", "usage"}], " ", "=", " ", 
   "\"\<ImportPts[fname_]: import CalLab/CalDe points file named \
fname.\\nReturns \
{world2tcpEuler,{sizeImageLeft,pointsLeft},{sizeImageRight,pointsRight}}\>\""}\
], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ImportStereoParameterFile", "::", "usage"}], "=", 
   "\"\<ImportStereoParameterFile[fname_,\\\"SM\\\"]: import 3rd, 5th, 7th \
order radial distortion camera parameter file in sensor-model \
format.\\nReturns \
{{resolution1,A1,k1,trfTcpTSensor1},{resolution2,A2,k2,trfTcpTSensor2},...}\\\
nImportStereoParameterFile[fname_,\\\"HH\\\"]: import camera parameter file \
in hh format.\\nReturns \
{resolution,{Aleft,kleft},{Aright,kright},trfRightTLeft,trfLeftTTcp}\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExportStereoParameterFile", "::", "usage"}], "=", 
   "\"\<ExportStereoParameterFile[fname_,\\\"HH\\\",{width_,height_},{Aleft_,\
kleft_},{Aright_,kright_},trfRightTLeft_,trfLeftTTcp_]: export camera \
parameter to file in hh format.\>\""}], ";"}]}], "Input",
 CellChangeTimes->{{3.433594851075493*^9, 3.433595275392414*^9}, {
  3.433595357350558*^9, 3.433595359795573*^9}, {3.433751688060846*^9, 
  3.433751707091785*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"import", " ", "calde", " ", "points", " ", 
    RowBox[{"file", ":", " ", 
     RowBox[{"{", 
      RowBox[{"world2tcp", ",", " ", 
       RowBox[{"{", 
        RowBox[{"sizeImageLeft", ",", "pointsLeft"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"sizeImageRight", ",", "pointsRight"}], "}"}]}], " "}]}]}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ImportPts", "[", "fname_", "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"is", "=", 
        RowBox[{"OpenRead", "[", "fname", "]"}]}], ",", "\[IndentingNewLine]",
        "world2tcpEuler", ",", "sizeImageLeft", ",", "sizeImageRight", ",", 
       "nPointsLeft", ",", "nPointsRight", ",", "pointsLeft", ",", 
       "pointsRight"}], "\[IndentingNewLine]", "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Skip", "[", 
       RowBox[{"is", ",", "String", ",", "2"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"world2tcpEuler", "=", 
       RowBox[{"ReadList", "[", 
        RowBox[{"is", ",", "Number", ",", "6"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Skip", "[", 
       RowBox[{"is", ",", "String", ",", "4"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sizeImageLeft", "=", 
       RowBox[{"ReadList", "[", 
        RowBox[{"is", ",", "Number", ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Skip", "[", 
       RowBox[{"is", ",", "String", ",", "2"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"nPointsLeft", "=", 
       RowBox[{"Read", "[", 
        RowBox[{"is", ",", "Number"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Skip", "[", 
       RowBox[{"is", ",", "String", ",", "2"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"pointsLeft", "=", 
       RowBox[{"ReadList", "[", 
        RowBox[{"is", ",", "Number", ",", 
         RowBox[{"5", " ", "nPointsLeft"}], ",", 
         RowBox[{"RecordLists", "\[Rule]", "True"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Skip", "[", 
       RowBox[{"is", ",", "String", ",", "4"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sizeImageRight", "=", 
       RowBox[{"ReadList", "[", 
        RowBox[{"is", ",", "Number", ",", "2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Skip", "[", 
       RowBox[{"is", ",", "String", ",", "2"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"nPointsRight", "=", 
       RowBox[{"Read", "[", 
        RowBox[{"is", ",", "Number"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<world2tcpEuler= \>\"", ",", "world2tcpEuler", ",", 
        "\[IndentingNewLine]", "\"\<\\nleft image \>\"", ",", "sizeImageLeft",
         ",", "\"\< #points= \>\"", ",", "nPointsLeft", ",", 
        "\[IndentingNewLine]", "\"\<\\nright image \>\"", ",", 
        "sizeImageRight", ",", "\"\< #points= \>\"", ",", "nPointsRight"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Skip", "[", 
       RowBox[{"is", ",", "String", ",", "2"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"pointsRight", "=", 
       RowBox[{"ReadList", "[", 
        RowBox[{"is", ",", "Number", ",", 
         RowBox[{"5", " ", "nPointsRight"}], ",", 
         RowBox[{"RecordLists", "\[Rule]", "True"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Close", "[", "is", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"world2tcpEuler", ",", 
        RowBox[{"{", 
         RowBox[{"sizeImageLeft", ",", "pointsLeft"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"sizeImageRight", ",", "pointsRight"}], "}"}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.419174298616433*^9, 3.419174374005003*^9}, {
   3.419174404671768*^9, 3.419174406774913*^9}, {3.419174445706271*^9, 
   3.419174490813283*^9}, {3.419175141716165*^9, 3.419175151234395*^9}, {
   3.41917518897553*^9, 3.419175258827238*^9}, 3.433592660518025*^9, {
   3.433594876406537*^9, 3.433594877054316*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ParseLine", "[", 
   RowBox[{"s_", ",", "\"\<SM\>\""}], "]"}], ":=", 
  RowBox[{"Select", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ImportString", "[", 
     RowBox[{
      RowBox[{"StringReplace", "[", 
       RowBox[{
        RowBox[{"StringReplace", "[", 
         RowBox[{"s", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\"\<:\>\"", "->", "\"\< \>\""}], " ", ",", 
            RowBox[{"\"\<;\>\"", "->", "\"\< \>\""}], ",", 
            RowBox[{"\"\<{\>\"", "->", "\"\< \>\""}], ",", 
            RowBox[{"\"\<}\>\"", "\[Rule]", "\"\< \>\""}], ",", 
            RowBox[{"\"\<,\>\"", "\[Rule]", "\"\< \>\""}]}], "}"}]}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\< \>\"", ".."}], "\[Rule]", "\"\<\\n\>\""}], "}"}]}], 
       "]"}], ",", "\"\<List\>\""}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"!", 
        RowBox[{"StringQ", "[", "#", "]"}]}], "||", 
       RowBox[{"0", "<", 
        RowBox[{"StringLength", "[", "#", "]"}]}]}], "&"}], ")"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ImportStereoParameterFile", "[", 
   RowBox[{"fname_", ",", "\"\<SM\>\""}], "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"is", "=", 
       RowBox[{"OpenRead", "[", "fname", "]"}]}], ",", "\[IndentingNewLine]", 
      "sLine", ",", 
      RowBox[{"iState", "=", "1"}], ",", "\[IndentingNewLine]", 
      RowBox[{"lElements", "=", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"iElement", "=", "1"}], ",", 
      RowBox[{"dElement", "=", "0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"nElementsRequired", "=", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "12", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",",
          "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"A", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"k", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", 
      RowBox[{"size", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"lCameras", "=", 
       RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", "trfTcpTSensor"}], 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"Not", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"sLine", "=", 
           RowBox[{"Read", "[", 
            RowBox[{"is", ",", "String"}], "]"}]}], ")"}], "===", 
         "EndOfFile"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<line= \>\"", ",", "sLine"}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"lElements", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"lElements", ",", 
           RowBox[{"ParseLine", "[", 
            RowBox[{"sLine", ",", "\"\<SM\>\""}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<lElements= \>\"", ",", "lElements", ",", 
            "\"\< Length[lElements]= \>\"", ",", 
            RowBox[{"Length", "[", "lElements", "]"}]}], "]"}], ";"}], "*)"}],
         "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<iState= \>\"", ",", "iState", ",", "\"\< iElement= \>\"", ",",
             "iElement"}], "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
           "nElementsRequired", "\[LeftDoubleBracket]", "iState", 
            "\[RightDoubleBracket]"}], "\[LessEqual]", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Length", "[", "lElements", "]"}], "-", "iElement"}], 
            ")"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"dElement", "=", 
            RowBox[{
            "nElementsRequired", "\[LeftDoubleBracket]", "iState", 
             "\[RightDoubleBracket]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"Print", "[", 
              RowBox[{
              "\"\<lElements\[LeftDoubleBracket]\>\"", ",", "iElement", ",", 
               "\"\<\[RightDoubleBracket]= \>\"", ",", 
               RowBox[{
               "lElements", "\[LeftDoubleBracket]", "iElement", 
                "\[RightDoubleBracket]"}]}], "]"}], ";"}], "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"Switch", "[", 
            RowBox[{"iState", ",", "\[IndentingNewLine]", "1", ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
               "\"\<SmGeneralDLRCallabDistortedCamera\>\"", "\[Equal]", 
                RowBox[{
                "lElements", "\[LeftDoubleBracket]", "iElement", 
                 "\[RightDoubleBracket]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"iState", "=", "2"}], ",", "\[IndentingNewLine]", 
               RowBox[{"Continue", "[", "]"}]}], "\[IndentingNewLine]", "]"}],
              ",", "\[IndentingNewLine]", "2", ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"\"\<sensor2Tcp\>\"", "==", 
                RowBox[{
                "lElements", "\[LeftDoubleBracket]", "iElement", 
                 "\[RightDoubleBracket]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"trfTcpTSensor", "=", 
                 RowBox[{"Append", "[", 
                  RowBox[{
                   RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"lElements", "\[LeftDoubleBracket]", 
                    RowBox[{
                    RowBox[{"iElement", "+", "1"}], ";;", 
                    RowBox[{"iElement", "+", "12"}]}], 
                    "\[RightDoubleBracket]"}], ",", "4"}], "]"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
                  "]"}]}], ";", "\[IndentingNewLine]", 
                RowBox[{"iState", "=", "3"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                "Print", "[", 
                 "\"\<parsing error while reading \\\"sensor2Tcp\\\"\>\"", 
                 "]"}], ";", 
                RowBox[{"Break", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}],
              ",", "\[IndentingNewLine]", "3", ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"\"\<mountIndex\>\"", "\[Equal]", 
                RowBox[{
                "lElements", "\[LeftDoubleBracket]", "iElement", 
                 "\[RightDoubleBracket]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"iState", "=", "4"}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                "Print", "[", 
                 "\"\<parsing error while reading \\\"mountIndex\\\"\>\"", 
                 "]"}], ";", 
                RowBox[{"Break", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}],
              ",", "\[IndentingNewLine]", "4", ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"\"\<width\>\"", "\[Equal]", 
                RowBox[{
                "lElements", "\[LeftDoubleBracket]", "iElement", 
                 "\[RightDoubleBracket]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "size", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], "=", 
                 RowBox[{"lElements", "\[LeftDoubleBracket]", 
                  RowBox[{"iElement", "+", "1"}], "\[RightDoubleBracket]"}]}],
                 ";", 
                RowBox[{"iState", "=", "5"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                "Print", "[", 
                 "\"\<parsing error while reading \\\"width\\\"\>\"", "]"}], 
                ";", 
                RowBox[{"Break", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}],
              ",", "\[IndentingNewLine]", "5", ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"\"\<height\>\"", "\[Equal]", 
                RowBox[{
                "lElements", "\[LeftDoubleBracket]", "iElement", 
                 "\[RightDoubleBracket]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "size", "\[LeftDoubleBracket]", "2", 
                  "\[RightDoubleBracket]"}], "=", 
                 RowBox[{"lElements", "\[LeftDoubleBracket]", 
                  RowBox[{"iElement", "+", "1"}], "\[RightDoubleBracket]"}]}],
                 ";", 
                RowBox[{"iState", "=", "6"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                "Print", "[", 
                 "\"\<parsing error while reading \\\"height\\\"\>\"", "]"}], 
                ";", 
                RowBox[{"Break", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}],
              ",", "\[IndentingNewLine]", "6", ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"\"\<scaleX\>\"", "\[Equal]", 
                RowBox[{
                "lElements", "\[LeftDoubleBracket]", "iElement", 
                 "\[RightDoubleBracket]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                 RowBox[{"A", "\[LeftDoubleBracket]", 
                  RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}], "=", 
                 RowBox[{"lElements", "\[LeftDoubleBracket]", 
                  RowBox[{"iElement", "+", "1"}], "\[RightDoubleBracket]"}]}],
                 ";", 
                RowBox[{"iState", "=", "7"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                "Print", "[", 
                 "\"\<parsing error while reading \\\"scaleX\\\"\>\"", "]"}], 
                ";", 
                RowBox[{"Break", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}],
              ",", "\[IndentingNewLine]", "7", ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"\"\<scaleY\>\"", "\[Equal]", 
                RowBox[{
                "lElements", "\[LeftDoubleBracket]", "iElement", 
                 "\[RightDoubleBracket]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                 RowBox[{"A", "\[LeftDoubleBracket]", 
                  RowBox[{"2", ",", "2"}], "\[RightDoubleBracket]"}], "=", 
                 RowBox[{"lElements", "\[LeftDoubleBracket]", 
                  RowBox[{"iElement", "+", "1"}], "\[RightDoubleBracket]"}]}],
                 ";", 
                RowBox[{"iState", "=", "8"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                "Print", "[", 
                 "\"\<parsing error while reading \\\"scaleY\\\"\>\"", "]"}], 
                ";", 
                RowBox[{"Break", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}],
              ",", "\[IndentingNewLine]", "8", ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"\"\<offsetX\>\"", "\[Equal]", 
                RowBox[{
                "lElements", "\[LeftDoubleBracket]", "iElement", 
                 "\[RightDoubleBracket]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                 RowBox[{"A", "\[LeftDoubleBracket]", 
                  RowBox[{"1", ",", "3"}], "\[RightDoubleBracket]"}], "=", 
                 RowBox[{"lElements", "\[LeftDoubleBracket]", 
                  RowBox[{"iElement", "+", "1"}], "\[RightDoubleBracket]"}]}],
                 ";", 
                RowBox[{"iState", "=", "9"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                "Print", "[", 
                 "\"\<parsing error while reading \\\"offsetX\\\"\>\"", "]"}],
                 ";", 
                RowBox[{"Break", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}],
              ",", "\[IndentingNewLine]", "9", ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"\"\<offsetY\>\"", "\[Equal]", 
                RowBox[{
                "lElements", "\[LeftDoubleBracket]", "iElement", 
                 "\[RightDoubleBracket]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                 RowBox[{"A", "\[LeftDoubleBracket]", 
                  RowBox[{"2", ",", "3"}], "\[RightDoubleBracket]"}], "=", 
                 RowBox[{"lElements", "\[LeftDoubleBracket]", 
                  RowBox[{"iElement", "+", "1"}], "\[RightDoubleBracket]"}]}],
                 ";", 
                RowBox[{"iState", "=", "10"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                "Print", "[", 
                 "\"\<parsing error while reading \\\"offsetY\\\"\>\"", "]"}],
                 ";", 
                RowBox[{"Break", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}],
              ",", "\[IndentingNewLine]", "10", ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"\"\<skew\>\"", "\[Equal]", 
                RowBox[{
                "lElements", "\[LeftDoubleBracket]", "iElement", 
                 "\[RightDoubleBracket]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                 RowBox[{"A", "\[LeftDoubleBracket]", 
                  RowBox[{"1", ",", "2"}], "\[RightDoubleBracket]"}], "=", 
                 RowBox[{"lElements", "\[LeftDoubleBracket]", 
                  RowBox[{"iElement", "+", "1"}], "\[RightDoubleBracket]"}]}],
                 ";", 
                RowBox[{"iState", "=", "11"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                "Print", "[", 
                 "\"\<parsing error while reading \\\"skew\\\"\>\"", "]"}], 
                ";", 
                RowBox[{"Break", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}],
              ",", "\[IndentingNewLine]", "11", ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"\"\<radial1\>\"", "\[Equal]", 
                RowBox[{
                "lElements", "\[LeftDoubleBracket]", "iElement", 
                 "\[RightDoubleBracket]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"k", "=", 
                 RowBox[{"{", 
                  RowBox[{"lElements", "\[LeftDoubleBracket]", 
                   RowBox[{"iElement", "+", "1"}], "\[RightDoubleBracket]"}], 
                  "}"}]}], ";", 
                RowBox[{"iState", "=", "12"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                "Print", "[", 
                 "\"\<parsing error while reading \\\"radial1\\\"\>\"", "]"}],
                 ";", 
                RowBox[{"Break", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}],
              ",", "\[IndentingNewLine]", "12", ",", 
             RowBox[{"Switch", "[", 
              RowBox[{
               RowBox[{
               "lElements", "\[LeftDoubleBracket]", "iElement", 
                "\[RightDoubleBracket]"}], ",", "\[IndentingNewLine]", 
               "\"\<SmGeneralDLRCallabDistortedCamera\>\"", ",", 
               RowBox[{
                RowBox[{"lCameras", "=", 
                 RowBox[{"Append", "[", 
                  RowBox[{"lCameras", ",", 
                   RowBox[{"{", 
                    RowBox[{
                    "size", ",", "A", ",", "k", ",", "trfTcpTSensor"}], 
                    "}"}]}], "]"}]}], ";", 
                RowBox[{"dElement", "=", "0"}], ";", 
                RowBox[{"iState", "=", "2"}]}], ",", "\[IndentingNewLine]", 
               "\"\<radial2\>\"", ",", 
               RowBox[{
                RowBox[{"k", "=", 
                 RowBox[{"Append", "[", 
                  RowBox[{"k", ",", 
                   RowBox[{"lElements", "\[LeftDoubleBracket]", 
                    RowBox[{"iElement", "+", "1"}], 
                    "\[RightDoubleBracket]"}]}], "]"}]}], ";", 
                RowBox[{"iState", "=", " ", "13"}]}], ",", 
               "\[IndentingNewLine]", "_", ",", 
               RowBox[{
                RowBox[{"lCameras", "=", 
                 RowBox[{"Append", "[", 
                  RowBox[{"lCameras", ",", 
                   RowBox[{"{", 
                    RowBox[{
                    "size", ",", "A", ",", "k", ",", "trfTcpTSensor"}], 
                    "}"}]}], "]"}]}], ";", 
                RowBox[{"iState", "=", " ", "1"}], ";", 
                RowBox[{"Continue", "[", "]"}]}]}], "\[IndentingNewLine]", 
              "]"}], ",", "\[IndentingNewLine]", "13", ",", 
             RowBox[{"Switch", "[", 
              RowBox[{
               RowBox[{
               "lElements", "\[LeftDoubleBracket]", "iElement", 
                "\[RightDoubleBracket]"}], ",", "\[IndentingNewLine]", 
               "\"\<SmGeneralDLRCallabDistortedCamera\>\"", ",", 
               RowBox[{
                RowBox[{"lCameras", "=", 
                 RowBox[{"Append", "[", 
                  RowBox[{"lCameras", ",", 
                   RowBox[{"{", 
                    RowBox[{
                    "size", ",", "A", ",", "k", ",", "trfTcpTSensor"}], 
                    "}"}]}], "]"}]}], ";", 
                RowBox[{"dElement", "=", "0"}], ";", 
                RowBox[{"iState", "=", "2"}]}], ",", "\[IndentingNewLine]", 
               "\"\<radial3\>\"", ",", 
               RowBox[{
                RowBox[{"k", "=", 
                 RowBox[{"Append", "[", 
                  RowBox[{"k", ",", 
                   RowBox[{"lElements", "\[LeftDoubleBracket]", 
                    RowBox[{"iElement", "+", "1"}], 
                    "\[RightDoubleBracket]"}]}], "]"}]}], ";", 
                RowBox[{"lCameras", "=", 
                 RowBox[{"Append", "[", 
                  RowBox[{"lCameras", ",", 
                   RowBox[{"{", 
                    RowBox[{
                    "size", ",", "A", ",", "k", ",", "trfTcpTSensor"}], 
                    "}"}]}], "]"}]}], ";", 
                RowBox[{"iState", "=", " ", "1"}]}], ",", 
               "\[IndentingNewLine]", "_", ",", 
               RowBox[{
                RowBox[{"lCameras", "=", 
                 RowBox[{"Append", "[", 
                  RowBox[{"lCameras", ",", 
                   RowBox[{"{", 
                    RowBox[{
                    "size", ",", "A", ",", "k", ",", "trfTcpTSensor"}], 
                    "}"}]}], "]"}]}], ";", 
                RowBox[{"iState", "=", " ", "1"}], ";", 
                RowBox[{"Continue", "[", "]"}]}]}], "\[IndentingNewLine]", 
              "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"iElement", "+=", 
            RowBox[{"dElement", "+", "1"}]}]}]}], "\[IndentingNewLine]", 
         "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"Close", "[", "is", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"not", " ", "yet", " ", "appended", " ", "camera"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"11", "<", "iState"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Append", "[", 
        RowBox[{"lCameras", ",", 
         RowBox[{"{", 
          RowBox[{"size", ",", "A", ",", "k", ",", "trfTcpTSensor"}], "}"}]}],
         "]"}], ",", "\[IndentingNewLine]", "lCameras"}], 
      "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.433579114982639*^9, 3.433579115070235*^9}, {
   3.433585028072947*^9, 3.433585049826131*^9}, {3.433585250860999*^9, 
   3.433585286271139*^9}, {3.433585326137696*^9, 3.433585368287579*^9}, {
   3.433585403641053*^9, 3.433585440452252*^9}, {3.433585755437603*^9, 
   3.433585797087724*^9}, {3.433585866870192*^9, 3.433585867237754*^9}, {
   3.43358605208485*^9, 3.433586077094884*^9}, {3.433586135045954*^9, 
   3.433586215314174*^9}, {3.433586267822882*^9, 3.43358641933293*^9}, {
   3.43358667815132*^9, 3.43358710170696*^9}, {3.433587150248175*^9, 
   3.433587411765604*^9}, {3.43358744993905*^9, 3.433587810271042*^9}, 
   3.433587860540714*^9, {3.433587902472549*^9, 3.43358790972273*^9}, {
   3.433587943077232*^9, 3.433588001946787*^9}, {3.433588032431981*^9, 
   3.433588320564169*^9}, {3.433588374001013*^9, 3.433588456561893*^9}, {
   3.433588603933341*^9, 3.433588637621303*^9}, {3.43358867324658*^9, 
   3.433588869124781*^9}, {3.433588900054036*^9, 3.433588936546587*^9}, {
   3.433588994038419*^9, 3.433589083975499*^9}, {3.433589158085574*^9, 
   3.433589182519125*^9}, 3.433589252340844*^9, {3.433589283679666*^9, 
   3.433589409223806*^9}, 3.433589557183037*^9, {3.433589729067917*^9, 
   3.43358977184293*^9}, {3.433589853870591*^9, 3.433589868252119*^9}, {
   3.43358990232257*^9, 3.433589924928397*^9}, {3.433590099964074*^9, 
   3.433590135425366*^9}, {3.433590231387094*^9, 3.433590249983367*^9}, 
   3.433590297770371*^9, {3.433590507387091*^9, 3.433590507984063*^9}, {
   3.433590658431654*^9, 3.433590732625645*^9}, {3.433743380556038*^9, 
   3.433743387368254*^9}, 3.433743421394708*^9, {3.433749750162641*^9, 
   3.43374989634879*^9}, {3.433750223213603*^9, 3.433750227892782*^9}, {
   3.433750387721912*^9, 3.433750512618879*^9}, {3.43375058589702*^9, 
   3.433750621422895*^9}, {3.433750678338361*^9, 3.43375070706355*^9}, 
   3.433750743666378*^9, {3.433750965162004*^9, 3.43375101282718*^9}, {
   3.433751059695219*^9, 3.433751098330737*^9}, {3.433751592220167*^9, 
   3.433751592424939*^9}, {3.433751646087802*^9, 3.43375164803762*^9}, {
   3.433751821652314*^9, 3.433751829423274*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"{", 
    RowBox[{"sizeImage", ",", 
     RowBox[{"{", 
      RowBox[{"Aleft", ",", "kleft"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Aright", ",", "kright"}], "}"}], ",", "trfRightTLeft", ",", 
     "trfLeftTTcp"}], "}"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ImportStereoParameterFile", "[", 
    RowBox[{"fname_", ",", "\"\<HH\>\""}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"is", "=", 
        RowBox[{"OpenRead", "[", 
         RowBox[{"\"\<!grep -v '#' \>\"", "<>", "fname"}], "]"}]}], ",", 
       "\[IndentingNewLine]", "sline", ",", "aline", ",", 
       "\[IndentingNewLine]", "Aleft", ",", "Aright", ",", 
       RowBox[{"kleft", "=", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], ",", 
       RowBox[{"kright", "=", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], ",", 
       RowBox[{"size", "=", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
       "rotRightTLeft", ",", "trnLeftTRight", ",", "\[IndentingNewLine]", 
       RowBox[{"rotLeftTTcp", "=", 
        RowBox[{"IdentityMatrix", "[", "3", "]"}]}], ",", 
       RowBox[{"trnLeftTTcp", "=", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}], "\[IndentingNewLine]", 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{"Not", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"sline", "=", 
            RowBox[{"Read", "[", 
             RowBox[{"is", ",", "String"}], "]"}]}], ")"}], "===", 
          "EndOfFile"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{"\"\<line= \>\"", ",", "sline"}], "]"}], ";"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"StringLength", "[", "sline", "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"aline", "=", 
            RowBox[{"ImportString", "[", 
             RowBox[{
              RowBox[{"StringReplace", "[", 
               RowBox[{
                RowBox[{"StringReplace", "[", 
                 RowBox[{"sline", ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"\"\<=\>\"", "->", "\"\< \>\""}], " ", ",", 
                    RowBox[{"\"\<;\>\"", "->", "\"\< \>\""}], ",", 
                    RowBox[{"\"\<[\>\"", "->", "\"\< \>\""}], ",", 
                    RowBox[{"\"\<]\>\"", "\[Rule]", "\"\< \>\""}], ",", 
                    RowBox[{"\"\<,\>\"", "\[Rule]", "\"\< \>\""}]}], "}"}]}], 
                 "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"\"\< \>\"", ".."}], "\[Rule]", "\"\<\\n\>\""}], 
                 "}"}]}], "]"}], ",", "\"\<List\>\""}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"Print", "[", 
              RowBox[{"\"\<aline= \>\"", ",", "aline"}], "]"}], ";"}], "*)"}],
            "\[IndentingNewLine]", 
           RowBox[{"Switch", "[", 
            RowBox[{
             RowBox[{
             "aline", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
             ",", "\[IndentingNewLine]", "\"\<left.A\>\"", ",", 
             RowBox[{"Aleft", "=", 
              RowBox[{"(", GridBox[{
                 {
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "2", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "3", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "4", 
                   "\[RightDoubleBracket]"}]},
                 {
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "5", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "6", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "7", 
                   "\[RightDoubleBracket]"}]}
                }], ")"}]}], ",", "\[IndentingNewLine]", "\"\<right.A\>\"", 
             ",", 
             RowBox[{"Aright", "=", 
              RowBox[{"(", GridBox[{
                 {
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "2", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "3", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "4", 
                   "\[RightDoubleBracket]"}]},
                 {
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "5", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "6", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "7", 
                   "\[RightDoubleBracket]"}]}
                }], ")"}]}], ",", "\[IndentingNewLine]", "\"\<left.k1\>\"", 
             ",", 
             RowBox[{
              RowBox[{
              "kleft", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
               "=", 
              RowBox[{
              "aline", "\[LeftDoubleBracket]", "2", 
               "\[RightDoubleBracket]"}]}], ",", "\[IndentingNewLine]", 
             "\"\<left.k2\>\"", ",", 
             RowBox[{
              RowBox[{
              "kleft", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
               "=", 
              RowBox[{
              "aline", "\[LeftDoubleBracket]", "2", 
               "\[RightDoubleBracket]"}]}], ",", "\[IndentingNewLine]", 
             "\"\<right.k1\>\"", ",", 
             RowBox[{
              RowBox[{
              "kright", "\[LeftDoubleBracket]", "1", 
               "\[RightDoubleBracket]"}], "=", 
              RowBox[{
              "aline", "\[LeftDoubleBracket]", "2", 
               "\[RightDoubleBracket]"}]}], ",", "\[IndentingNewLine]", 
             "\"\<right.k2\>\"", ",", 
             RowBox[{
              RowBox[{
              "kright", "\[LeftDoubleBracket]", "2", 
               "\[RightDoubleBracket]"}], "=", 
              RowBox[{
              "aline", "\[LeftDoubleBracket]", "2", 
               "\[RightDoubleBracket]"}]}], ",", "\[IndentingNewLine]", 
             "\"\<video.width\>\"", ",", 
             RowBox[{
              RowBox[{
              "size", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
              "=", 
              RowBox[{
              "aline", "\[LeftDoubleBracket]", "2", 
               "\[RightDoubleBracket]"}]}], ",", "\[IndentingNewLine]", 
             "\"\<video.height\>\"", ",", 
             RowBox[{
              RowBox[{
              "size", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
              "=", 
              RowBox[{
              "aline", "\[LeftDoubleBracket]", "2", 
               "\[RightDoubleBracket]"}]}], ",", "\[IndentingNewLine]", 
             "\"\<T\>\"", ",", 
             RowBox[{"trnLeftTRight", "=", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                "aline", "\[LeftDoubleBracket]", "2", 
                 "\[RightDoubleBracket]"}], ",", 
                RowBox[{
                "aline", "\[LeftDoubleBracket]", "3", 
                 "\[RightDoubleBracket]"}], ",", 
                RowBox[{
                "aline", "\[LeftDoubleBracket]", "4", 
                 "\[RightDoubleBracket]"}]}], "}"}]}], ",", 
             "\[IndentingNewLine]", "\"\<R\>\"", ",", 
             RowBox[{"rotRightTLeft", "=", 
              RowBox[{"(", GridBox[{
                 {
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "2", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "3", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "4", 
                   "\[RightDoubleBracket]"}]},
                 {
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "5", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "6", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "7", 
                   "\[RightDoubleBracket]"}]},
                 {
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "8", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "9", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "10", 
                   "\[RightDoubleBracket]"}]}
                }], ")"}]}], ",", "\[IndentingNewLine]", "\"\<Tc\>\"", ",", 
             RowBox[{"trnLeftTTcp", "=", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                "aline", "\[LeftDoubleBracket]", "2", 
                 "\[RightDoubleBracket]"}], ",", 
                RowBox[{
                "aline", "\[LeftDoubleBracket]", "3", 
                 "\[RightDoubleBracket]"}], ",", 
                RowBox[{
                "aline", "\[LeftDoubleBracket]", "4", 
                 "\[RightDoubleBracket]"}]}], "}"}]}], ",", 
             "\[IndentingNewLine]", "\"\<Rc\>\"", ",", 
             RowBox[{"rotLeftTTcp", "=", 
              RowBox[{"(", GridBox[{
                 {
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "2", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "3", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "4", 
                   "\[RightDoubleBracket]"}]},
                 {
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "5", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "6", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "7", 
                   "\[RightDoubleBracket]"}]},
                 {
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "8", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "9", 
                   "\[RightDoubleBracket]"}], 
                  RowBox[{
                  "aline", "\[LeftDoubleBracket]", "10", 
                   "\[RightDoubleBracket]"}]}
                }], ")"}]}]}], "\[IndentingNewLine]", "]"}]}]}], 
         "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Close", "[", "is", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"size", ",", 
        RowBox[{"{", 
         RowBox[{"Aleft", ",", "kleft"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Aright", ",", "kright"}], "}"}], ",", "\[IndentingNewLine]",
         
        RowBox[{"Append", "[", 
         RowBox[{
          RowBox[{"Join", "[", 
           RowBox[{"rotRightTLeft", ",", 
            RowBox[{"Transpose", "[", 
             RowBox[{"{", 
              RowBox[{"-", 
               RowBox[{"rotRightTLeft", ".", "trnLeftTRight"}]}], "}"}], 
             "]"}], ",", "2"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Append", "[", 
         RowBox[{
          RowBox[{"Join", "[", 
           RowBox[{"rotLeftTTcp", ",", 
            RowBox[{"Transpose", "[", 
             RowBox[{"{", "trnLeftTTcp", "}"}], "]"}], ",", "2"}], "]"}], ",",
           
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "]"}]}], 
       "\[IndentingNewLine]", "}"}]}]}], "\[IndentingNewLine]", 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.419084272201295*^9, 3.419084274804574*^9}, {
   3.41908443374855*^9, 3.419084449052011*^9}, {3.419084560190961*^9, 
   3.419084599399397*^9}, {3.419084679558461*^9, 3.419084688631524*^9}, {
   3.41908491867577*^9, 3.419084935961668*^9}, {3.419084994466241*^9, 
   3.419085001336276*^9}, {3.419154633151205*^9, 3.419154641076811*^9}, {
   3.419173171269005*^9, 3.419173252318573*^9}, {3.41917332834298*^9, 
   3.419173333247993*^9}, {3.421485681168409*^9, 3.42148569251777*^9}, {
   3.421485735203699*^9, 3.421485816573888*^9}, {3.421485871653409*^9, 
   3.421485904562777*^9}, 3.421486013806751*^9, 3.433592815916991*^9, {
   3.433593668792471*^9, 3.433593733164809*^9}, {3.433593896272801*^9, 
   3.433593907718913*^9}, {3.433594178235166*^9, 3.433594251849523*^9}, {
   3.433594374307433*^9, 3.433594376938342*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ExportStereoParameterFile", "[", 
    RowBox[{"fname_", ",", "\"\<HH\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"width_", ",", "height_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Aleft_", ",", "kleft_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Aright_", ",", "kright_"}], "}"}], ",", "trfRightTLeft_", ",", 
     "trfLeftTTcp_"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"os", "=", 
        RowBox[{"OpenWrite", "[", "fname", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"trfLeftTRight", "=", 
        RowBox[{"Inverse", "[", "trfRightTLeft", "]"}]}]}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"WriteString", "[", 
       RowBox[{"os", ",", "\"\<left.A=[ \>\"", ",", 
        RowBox[{"Aleft", "\[LeftDoubleBracket]", 
         RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"Aleft", "\[LeftDoubleBracket]", 
         RowBox[{"1", ",", "2"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"Aleft", "\[LeftDoubleBracket]", 
         RowBox[{"1", ",", "3"}], "\[RightDoubleBracket]"}], ",", 
        "\"\<; \>\"", ",", 
        RowBox[{"Aleft", "\[LeftDoubleBracket]", 
         RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"Aleft", "\[LeftDoubleBracket]", 
         RowBox[{"2", ",", "2"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"Aleft", "\[LeftDoubleBracket]", 
         RowBox[{"2", ",", "3"}], "\[RightDoubleBracket]"}], ",", 
        "\"\<; 0 0 1 ]\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{"os", ",", "\"\<left.k2= \>\"", ",", 
        RowBox[{
        "kleft", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], ",", 
        "\"\<\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{"os", ",", "\"\<left.k1= \>\"", ",", 
        RowBox[{
        "kleft", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
        "\"\<\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{"os", ",", "\"\<T=[ \>\"", ",", 
        RowBox[{"trfLeftTRight", "\[LeftDoubleBracket]", 
         RowBox[{"1", ",", "4"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"trfLeftTRight", "\[LeftDoubleBracket]", 
         RowBox[{"2", ",", "4"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"trfLeftTRight", "\[LeftDoubleBracket]", 
         RowBox[{"3", ",", "4"}], "\[RightDoubleBracket]"}], ",", 
        "\"\< ]\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{"os", ",", "\"\<R=[ \>\"", ",", 
        RowBox[{"trfRightTLeft", "\[LeftDoubleBracket]", 
         RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"trfRightTLeft", "\[LeftDoubleBracket]", 
         RowBox[{"1", ",", "2"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"trfRightTLeft", "\[LeftDoubleBracket]", 
         RowBox[{"1", ",", "3"}], "\[RightDoubleBracket]"}], ",", 
        "\"\<; \>\"", ",", 
        RowBox[{"trfRightTLeft", "\[LeftDoubleBracket]", 
         RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"trfRightTLeft", "\[LeftDoubleBracket]", 
         RowBox[{"2", ",", "2"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"trfRightTLeft", "\[LeftDoubleBracket]", 
         RowBox[{"2", ",", "3"}], "\[RightDoubleBracket]"}], ",", 
        "\"\<; \>\"", ",", 
        RowBox[{"trfRightTLeft", "\[LeftDoubleBracket]", 
         RowBox[{"3", ",", "1"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"trfRightTLeft", "\[LeftDoubleBracket]", 
         RowBox[{"3", ",", "2"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"trfRightTLeft", "\[LeftDoubleBracket]", 
         RowBox[{"3", ",", "3"}], "\[RightDoubleBracket]"}], ",", 
        "\"\< ]\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{"os", ",", "\"\<right.A=[ \>\"", ",", 
        RowBox[{"Aright", "\[LeftDoubleBracket]", 
         RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"Aright", "\[LeftDoubleBracket]", 
         RowBox[{"1", ",", "2"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"Aright", "\[LeftDoubleBracket]", 
         RowBox[{"1", ",", "3"}], "\[RightDoubleBracket]"}], ",", 
        "\"\<; \>\"", ",", 
        RowBox[{"Aright", "\[LeftDoubleBracket]", 
         RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"Aright", "\[LeftDoubleBracket]", 
         RowBox[{"2", ",", "2"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"Aright", "\[LeftDoubleBracket]", 
         RowBox[{"2", ",", "3"}], "\[RightDoubleBracket]"}], ",", 
        "\"\<; 0 0 1 ]\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{"os", ",", "\"\<right.k2= \>\"", ",", 
        RowBox[{
        "kright", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
        ",", "\"\<\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{"os", ",", "\"\<right.k1= \>\"", ",", 
        RowBox[{
        "kright", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
        ",", "\"\<\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{
       "os", ",", "\"\<video.width= \>\"", ",", "width", ",", "\"\<\\n\>\""}],
        "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{
       "os", ",", "\"\<video.height= \>\"", ",", "height", ",", 
        "\"\<\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{"os", ",", "\"\<Rc=[ \>\"", ",", 
        RowBox[{"trfLeftTTcp", "\[LeftDoubleBracket]", 
         RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"trfLeftTTcp", "\[LeftDoubleBracket]", 
         RowBox[{"1", ",", "2"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"trfLeftTTcp", "\[LeftDoubleBracket]", 
         RowBox[{"1", ",", "3"}], "\[RightDoubleBracket]"}], ",", 
        "\"\<; \>\"", ",", 
        RowBox[{"trfLeftTTcp", "\[LeftDoubleBracket]", 
         RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"trfLeftTTcp", "\[LeftDoubleBracket]", 
         RowBox[{"2", ",", "2"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"trfLeftTTcp", "\[LeftDoubleBracket]", 
         RowBox[{"2", ",", "3"}], "\[RightDoubleBracket]"}], ",", 
        "\"\<; \>\"", ",", 
        RowBox[{"trfLeftTTcp", "\[LeftDoubleBracket]", 
         RowBox[{"3", ",", "1"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"trfLeftTTcp", "\[LeftDoubleBracket]", 
         RowBox[{"3", ",", "2"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"trfLeftTTcp", "\[LeftDoubleBracket]", 
         RowBox[{"3", ",", "3"}], "\[RightDoubleBracket]"}], ",", 
        "\"\< ]\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{"os", ",", "\"\<Tc=[ \>\"", ",", 
        RowBox[{"trfLeftTTcp", "\[LeftDoubleBracket]", 
         RowBox[{"1", ",", "4"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"trfLeftTTcp", "\[LeftDoubleBracket]", 
         RowBox[{"2", ",", "4"}], "\[RightDoubleBracket]"}], ",", "\"\< \>\"",
         ",", 
        RowBox[{"trfLeftTTcp", "\[LeftDoubleBracket]", 
         RowBox[{"3", ",", "4"}], "\[RightDoubleBracket]"}], ",", 
        "\"\< ]\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Close", "[", "os", "]"}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.421244255732101*^9, 3.421244300197455*^9}, 
   3.421244332577669*^9, {3.421244465695094*^9, 3.421244518673318*^9}, {
   3.42124456388267*^9, 3.421244569800713*^9}, {3.421244809825579*^9, 
   3.421244887297077*^9}, {3.421244921998947*^9, 3.4212449263618*^9}, {
   3.421244962990373*^9, 3.421245203006174*^9}, {3.421245238394362*^9, 
   3.421245296943546*^9}, {3.421245331820383*^9, 3.421245452314659*^9}, {
   3.421245483604735*^9, 3.421245491008112*^9}, {3.421245857478067*^9, 
   3.421245864067788*^9}, {3.421485832562597*^9, 3.421485836512442*^9}, {
   3.421486065162954*^9, 3.421486094593607*^9}, {3.421665201720473*^9, 
   3.421665218182649*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Projection & Distortion Functions", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.433593194426979*^9, 3.433593214684346*^9}, {
  3.433595709341324*^9, 3.433595712996987*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqr", "[", "x_", "]"}], ":=", 
  RowBox[{"x", ".", "x"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"undistorted2normalized", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_"}], "}"}], ",", "A_"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", 
       RowBox[{"A", "\[LeftDoubleBracket]", 
        RowBox[{"1", ",", "3"}], "\[RightDoubleBracket]"}]}], ")"}], "/", 
     RowBox[{"A", "\[LeftDoubleBracket]", 
      RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"y", "-", 
       RowBox[{"A", "\[LeftDoubleBracket]", 
        RowBox[{"2", ",", "3"}], "\[RightDoubleBracket]"}]}], ")"}], "/", 
     RowBox[{"A", "\[LeftDoubleBracket]", 
      RowBox[{"2", ",", "2"}], "\[RightDoubleBracket]"}]}]}], 
   "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"3", "rd"}], " ", "&"}], " ", "5", "th", " ", "order", " ", 
    "radial", " ", "distortion"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"normalized2distortednormalized", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xn_", ",", "yn_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k1_", ",", "k2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r", "=", 
       RowBox[{
        RowBox[{"xn", "*", "xn"}], "+", 
        RowBox[{"yn", "*", "yn"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"k1", " ", "r"}], "+", 
        RowBox[{"k2", " ", 
         SuperscriptBox["r", "2"]}]}], ")"}], 
      RowBox[{"{", 
       RowBox[{"xn", ",", "yn"}], "}"}]}]}], "\[IndentingNewLine]", 
    "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"distortednormalized2distorted", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"xdn_", ",", "ydn_"}], "}"}], ",", "A_"}], "]"}], ":=", 
  RowBox[{"A", ".", 
   RowBox[{"{", 
    RowBox[{"xdn", ",", "ydn", ",", "1"}], "}"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"undistorted2distorted", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_"}], "}"}], ",", "A_", ",", "k_"}], "]"}], ":=", 
  " ", 
  RowBox[{"distortednormalized2distorted", "[", 
   RowBox[{
    RowBox[{"normalized2distortednormalized", "[", 
     RowBox[{
      RowBox[{"undistorted2normalized", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", "A"}], "]"}], ",", "k"}], "]"}],
     ",", "A"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"distorted2undistorted", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_"}], "}"}], ",", "A_", ",", "k_"}], "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"sol", "=", 
      RowBox[{"FindMinimum", "[", 
       RowBox[{
        RowBox[{"Sqr", "[", 
         RowBox[{
          RowBox[{"undistorted2distorted", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"xu", ",", "yu"}], "}"}], ",", "A", ",", "k"}], "]"}], 
          "-", 
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"xu", ",", "x"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"yu", ",", "y"}], "}"}]}], "}"}]}], "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xu", ",", "yu"}], "}"}], "/.", 
     RowBox[{
     "sol", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sensor2normalized", "[", 
   RowBox[{"{", 
    RowBox[{"x_", ",", "y_", ",", "z_"}], "}"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    FractionBox["x", "z"], ",", 
    FractionBox["y", "z"]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.433592548281013*^9, 3.433592551165927*^9}, 
   3.433592583361403*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sensor2distorted", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_", ",", "z_"}], "}"}], ",", "A_", ",", "k_"}], 
   "]"}], ":=", 
  RowBox[{"distortednormalized2distorted", "[", 
   RowBox[{
    RowBox[{"normalized2distortednormalized", "[", 
     RowBox[{
      RowBox[{"sensor2normalized", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}], ",", "k"}], "]"}], 
    ",", "A"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sensor2distorted", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_", ",", "z_", ",", "1."}], "}"}], ",", "A_", ",", 
    "k_"}], "]"}], ":=", 
  RowBox[{"sensor2distorted", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "A", ",", "k"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sensor2distorted", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_", ",", "z_", ",", "1"}], "}"}], ",", "A_", ",", 
    "k_"}], "]"}], ":=", 
  RowBox[{"sensor2distorted", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "A", ",", "k"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.433592587170873*^9, 3.433592590603424*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Section",
 CellChangeTimes->{{3.433593261504615*^9, 3.433593262401649*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "read", " ", "file", " ", "containing", " ", "detected", " ", "corner", 
    " ", 
    RowBox[{"points", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"world2tcp", ",", 
      RowBox[{"{", 
       RowBox[{"sizeImageLeft", ",", "pointsLeft"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"sizeImageRight", ",", "pointsRight"}], "}"}]}], "}"}], "=", 
    RowBox[{"ReadPts", "[", "\"\<shot0.pts\>\"", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{
  3.433593309672793*^9, 3.433593355218144*^9, {3.433595424935637*^9, 
   3.433595439849665*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"worl2tcpEuler= \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`"}], 
    "}"}]}],
  SequenceForm["worl2tcpEuler= ", {0., 0., 0., 0., 0., 0.}],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"left image \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"640", ",", "480"}], "}"}], 
   "\[InvisibleSpace]", "\<\" #points= \"\>", "\[InvisibleSpace]", "35"}],
  SequenceForm["left image ", {640, 480}, " #points= ", 35],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"right image \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"640", ",", "480"}], "}"}], 
   "\[InvisibleSpace]", "\<\" #points= \"\>", "\[InvisibleSpace]", "35"}],
  SequenceForm["right image ", {640, 480}, " #points= ", 35],
  Editable->False]], "Print"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"read", " ", "file", " ", "containing", " ", "camera", " ", 
    RowBox[{"parameters", "."}]}], " ", "*)"}], 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"sizeImage", ",", 
     RowBox[{"{", 
      RowBox[{"Aleft", ",", "kleft"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Aright", ",", "kright"}], "}"}], ",", "trfRightTleft", ",", 
     "trfLeftTTcp"}], "}"}], "=", 
   RowBox[{"InterpretStereoParameterFile", "[", 
    RowBox[{"\"\<camera_calibration_callab_hh.par\>\"", ",", "\"\<HH\>\""}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.433593280581271*^9, 3.43359328359602*^9}, {
  3.433593360682339*^9, 3.433593389508855*^9}, {3.433593575779838*^9, 
  3.433593601573441*^9}, {3.433595444193559*^9, 3.433595491309532*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"undistort", " ", "left", " ", "camera", " ", 
    RowBox[{"points", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"pointsUndistortedLeft", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"distorted2undistorted", "[", 
       RowBox[{"#", ",", "Aleft", ",", "kleft"}], "]"}], "&"}], "/@", 
     RowBox[{"pointsLeft", "\[LeftDoubleBracket]", 
      RowBox[{"All", ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}]}], "\[RightDoubleBracket]"}]}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.433595504173971*^9, 3.433595529167989*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"pointsLeft", "\[LeftDoubleBracket]", 
      RowBox[{"All", ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}]}], "\[RightDoubleBracket]"}], "]"}], 
    ",", 
    RowBox[{"Transpose", "[", "pointsUndistortedLeft", "]"}]}], "]"}], "//", 
  "TableForm"}]], "Input"],

Cell[BoxData[
 TagBox[GridBox[{
    {"64.7556`", "109.049`", "153.886`", "199.612`", "246.154`", "293.31`", 
     "340.937`", "388.506`", "436.082`", "483.635`", "530.441`", "576.727`", 
     "621.935`", "666.35`", "709.773`", "752.106`", "60.6705`", "105.065`", 
     "150.378`", "196.65`", "243.675`", "291.213`", "339.564`", "387.71`", 
     "436.14`", "483.94`", "531.558`", "578.02`", "623.985`", "668.519`", 
     "712.197`", "754.793`", "56.605`", "101.228`", "146.859`", "193.627`", 
     "241.101`", "289.367`", "338.18`", "386.966`", "435.818`", "484.193`", 
     "532.021`", "579.49`", "625.54`", "670.604`", "714.443`", "757.524`", 
     "52.962`", "97.9288`", "143.951`", "190.848`", "238.932`", "287.493`", 
     "336.843`", "386.067`", "435.458`", "484.194`", "532.722`", "580.198`", 
     "626.771`", "672.198`", "716.453`", "759.615`", "49.5184`", "94.854`", 
     "140.908`", "188.597`", "236.87`", "285.883`", "335.422`", "385.187`", 
     "434.744`", "484.143`", "532.981`", "580.954`", "627.769`", "673.641`", 
     "718.029`", "761.317`", "46.88`", "92.1894`", "138.701`", "186.274`", 
     "234.889`", "284.213`", "334.249`", "384.193`", "434.287`", "483.995`", 
     "533.19`", "581.203`", "628.363`", "674.235`", "719.102`", "762.373`", 
     "44.2721`", "90.1057`", "136.675`", "184.629`", "233.194`", "282.892`", 
     "332.967`", "383.296`", "433.522`", "483.559`", "532.874`", "581.257`", 
     "628.466`", "674.734`", "719.568`", "763.156`", "42.5378`", "88.1187`", 
     "135.025`", "182.871`", "231.968`", "281.541`", "332.053`", "382.222`", 
     "432.799`", "482.706`", "532.312`", "580.829`", "628.219`", "674.405`", 
     "719.657`", "763.335`", "40.8929`", "86.9117`", "133.814`", "182.034`", 
     "230.805`", "280.621`", "330.792`", "381.363`", "431.866`", "482.028`", 
     "531.446`", "580.097`", "627.497`", "674.046`", "718.958`", "762.98`", 
     "40.2917`", "85.9344`", "133.042`", "180.961`", "229.992`", "279.565`", 
     "330.065`", "380.264`", "430.819`", "480.694`", "530.371`", "578.764`", 
     "626.368`", "672.803`", "717.972`", "762.106`", "39.6959`", "85.7506`", 
     "132.484`", "180.598`", "229.321`", "278.976`", "328.959`", "379.42`", 
     "429.686`", "479.642`", "528.949`", "577.478`", "624.686`", "671.425`", 
     "716.391`", "760.607`", "39.884`", "85.5969`", "132.558`", "180.231`", 
     "229.054`", "278.34`", "328.369`", "378.342`", "428.502`", "478.071`", 
     "527.307`", "575.681`", "622.918`", "669.373`", "714.694`", "758.767`"},
    {"23.4274`", "22.3266`", "21.3438`", "20.6227`", "20.1058`", "20.2646`", 
     "20.6334`", "21.2631`", "22.7136`", "24.2786`", "26.1697`", "28.5769`", 
     "31.0793`", "33.8906`", "36.9427`", "40.1268`", "67.2114`", "66.3889`", 
     "65.5267`", "65.0865`", "64.7856`", "64.8416`", "65.2562`", "66.2618`", 
     "67.2968`", "68.9507`", "70.6883`", "72.9268`", "75.1432`", "77.8272`", 
     "80.7508`", "83.4019`", "112.178`", "111.598`", "111.076`", "110.784`", 
     "110.807`", "110.885`", "111.51`", "112.304`", "113.521`", "115.015`", 
     "116.761`", "118.563`", "120.691`", "123.052`", "125.359`", "128.005`", 
     "158.094`", "157.901`", "157.738`", "157.733`", "157.92`", "158.335`", 
     "158.98`", "159.789`", "160.837`", "162.063`", "163.624`", "165.271`", 
     "167.118`", "169.085`", "171.112`", "172.97`", "204.852`", "205.119`", 
     "205.353`", "205.715`", "206.116`", "206.767`", "207.554`", "208.4`", 
     "209.421`", "210.601`", "211.865`", "213.134`", "214.654`", "216.245`", 
     "217.752`", "219.06`", "252.457`", "253.16`", "253.792`", "254.408`", 
     "255.143`", "256.012`", "256.965`", "257.833`", "258.783`", "259.8`", 
     "260.71`", "261.879`", "262.918`", "263.917`", "264.893`", "265.95`", 
     "300.726`", "301.85`", "302.971`", "303.925`", "304.876`", "305.922`", 
     "306.989`", "307.989`", "308.748`", "309.67`", "310.35`", "310.961`", 
     "311.638`", "312.094`", "312.714`", "313.116`", "349.151`", "350.608`", 
     "352.161`", "353.67`", "354.909`", "356.196`", "357.257`", "358.175`", 
     "359.052`", "359.707`", "360.067`", "360.443`", "360.668`", "360.863`", 
     "360.731`", "360.71`", "397.674`", "399.791`", "401.654`", "403.405`", 
     "405.075`", "406.409`", "407.753`", "408.522`", "409.423`", "409.904`", 
     "410.185`", "410.03`", "409.979`", "409.443`", "408.987`", "408.253`", 
     "446.`", "448.462`", "450.825`", "452.951`", "454.785`", "456.425`", 
     "457.899`", "458.877`", "459.538`", "459.794`", "459.763`", "459.395`", 
     "458.813`", "457.939`", "456.93`", "455.893`", "494.099`", "496.903`", 
     "499.735`", "501.964`", "504.191`", "506.016`", "507.353`", "508.364`", 
     "508.823`", "508.957`", "508.839`", "508.207`", "507.39`", "506.146`", 
     "504.749`", "503.256`", "541.773`", "544.776`", "547.876`", "550.578`", 
     "552.844`", "554.865`", "556.204`", "557.474`", "557.88`", "557.917`", 
     "557.434`", "556.472`", "555.346`", "553.957`", "552.038`", "550.147`"},
    {"44.11508077615198`", "93.60944033922274`", "142.6551266498959`", 
     "191.71105957023755`", "240.81901590767055`", "289.9497555040744`", 
     "339.1467195682813`", "388.09921644257975`", "437.1109574781267`", 
     "486.3898564446986`", "535.4080216036041`", "584.5900744956213`", 
     "633.5064373942423`", "682.5529313397977`", "731.5414329448911`", 
     "780.2988732260336`", "42.05692498792991`", "91.52418086492771`", 
     "140.86303525429048`", "190.21554014339145`", "239.48993118635235`", 
     "288.63293754380175`", "338.1708384822051`", "387.3024713651933`", 
     "436.7788243263372`", "485.91308077791075`", "535.408388832814`", 
     "584.4486867198051`", "633.9128816437006`", "682.8870924520693`", 
     "732.0432965805292`", "781.1090968339877`", "39.740913172703245`", 
     "89.34005167463229`", "138.8406193938936`", "188.47259583959504`", 
     "237.93036510244679`", "287.4982319177912`", "337.1628409607356`", 
     "386.5907790395338`", "436.1422214102822`", "485.52556829986645`", 
     "534.9136744277195`", "584.7354642206077`", "634.0496933380639`", 
     "683.4321125227594`", "732.6806534269259`", "782.2788143751347`", 
     "37.52405222998388`", "87.411029772991`", "137.18471747415057`", 
     "186.75813202475885`", "236.61769584486598`", "286.2333934033293`", 
     "336.1661874318851`", "385.7541901112043`", "435.5684288304482`", 
     "485.04893423890144`", "534.9057975709568`", "584.5052578801276`", 
     "634.1862766927693`", "683.8256431415358`", "733.4565784945069`", 
     "783.1483857723534`", "35.081200680643356`", "85.32532636832755`", 
     "135.04142245901807`", "185.32072096431315`", "235.21313560763735`", 
     "285.1087935941475`", "335.03717688540013`", "384.967380506237`", 
     "434.7458700178589`", "484.70157280377634`", "534.6947792765386`", 
     "584.6536806073597`", "634.462230495578`", "684.4942518260103`", 
     "734.2265452616973`", "784.0600825983402`", "33.034943010087424`", 
     "83.23417203018626`", "133.40250105750644`", "183.49487327606403`", 
     "233.66128609090845`", "283.77679197225706`", "334.0975514751874`", 
     "384.0936312604844`", "434.29700007964186`", "484.45632113069496`", 
     "534.7162783317774`", "584.6303061723571`", "634.7378888156808`", 
     "684.7231475479051`", "734.9709212689161`", "784.789900558838`", 
     "30.464920769055276`", "81.28132987993759`", "131.53326310380334`", 
     "182.03586128920554`", "232.14893209622795`", "282.63455965763217`", 
     "332.9783936428314`", "383.34061640119853`", "433.65501067762426`", 
     "484.12752836393605`", "534.4946475724779`", "584.7852903190944`", 
     "634.9459763683909`", "685.3731073434473`", "735.6053973921191`", 
     "785.8170755338856`", "28.289900851592247`", "78.91153293497533`", 
     "129.6172498884938`", "180.0957003383848`", "230.84506952542475`", 
     "281.28554098098743`", "332.14889793110353`", "382.42786486191414`", 
     "433.1712061896216`", "483.58685987187465`", "534.3234034335536`", 
     "584.8268254677108`", "635.2506536385312`", "685.6550724052447`", 
     "736.4092266336215`", "786.7718828399705`", "25.62294297680012`", 
     "76.86019960627999`", "127.71138950289352`", "178.74538582859466`", 
     "229.32429458030245`", "280.1880521840869`", "330.8847338811916`", 
     "381.74379787974885`", "432.58869171823534`", "483.4343166272792`", 
     "534.1467592419326`", "584.9420060693309`", "635.5215019774868`", 
     "686.4420004024212`", "736.913983423929`", "787.7215028805899`", 
     "23.562441758164294`", "74.54547558312552`", "125.82566307552763`", 
     "176.777139095978`", "227.88376820769494`", "278.7643665203081`", 
     "330.06744371055476`", "380.8263086034756`", "431.9959981329858`", 
     "482.8126938804412`", "534.0421584927064`", "584.8014101739517`", 
     "635.8011637481967`", "686.7692125117161`", "737.6492246788849`", 
     "788.654066534925`", "20.97461910951986`", "72.61455661926769`", 
     "123.73531295413768`", "175.2020885551982`", "226.31400034585556`", 
     "277.631368161784`", "328.77398798014826`", "380.1663187549272`", 
     "431.40627032605033`", "482.659746715643`", "533.846688958757`", 
     "585.0580925172834`", "635.9046118453791`", "687.4235358840275`", 
     "738.2193758648446`", "789.3668375342917`", "18.820252378282696`", 
     "70.28639072501225`", "121.94795705291058`", "173.2889711808351`", 
     "224.91234290642606`", "276.27583589021543`", "327.9155117887762`", 
     "379.26468901079556`", "430.8506301305044`", "482.14459197017334`", 
     "533.6653642359587`", "585.0817216174532`", "636.2767028077232`", 
     "687.7364591504704`", "739.07216472159`", "790.0782766671229`"},
    {"6.14976678795984`", "7.394289845238759`", "8.50116289090922`", 
     "9.572217528104362`", "10.482145164921013`", "11.69649006259197`", 
     "12.6755501840795`", "13.45928685685295`", "14.65901492978265`", 
     "15.516650228580044`", "16.300478318104847`", "17.253096284743567`", 
     "17.98956606883008`", "18.80253776383082`", "19.714804002392256`", 
     "20.71950094619341`", "54.28634177893575`", "55.55281401449269`", 
     "56.54349995786165`", "57.697860346539834`", "58.65755919986226`", 
     "59.61922332678987`", "60.566283986241174`", "61.725372615379705`", 
     "62.504425012711806`", "63.546510238241325`", "64.29858449342363`", 
     "65.2612667259532`", "65.89938456099793`", "66.83254436504926`", 
     "67.86636590947164`", "68.53765512300926`", "102.87329295523021`", 
     "104.0491746264503`", "105.08689590698468`", "106.1252942593719`", 
     "107.20515987555703`", "108.0328612551759`", "109.10107791440488`", 
     "110.00678841245114`", "111.01783533755558`", "111.99659629667441`", 
     "112.93799957187086`", "113.65537598290618`", "114.49356323462455`", 
     "115.39203426519683`", "116.10956425697728`", "117.11756922423272`", 
     "151.76726260535045`", "152.9447259307946`", "153.99204497868718`", 
     "155.00679683247938`", "156.00544913173388`", "156.99628881480558`", 
     "157.97515079934783`", "158.86641896842985`", "159.75128643050863`", 
     "160.58003120428992`", "161.5240946177046`", "162.35907495015078`", 
     "163.22759422431756`", "164.08605091872252`", "164.91386031009583`", 
     "165.51331732514`", "200.99084280749625`", "202.19363583285582`", 
     "203.23945534830037`", "204.29098433243166`", "205.22746923111401`", 
     "206.25861152604128`", "207.26262391723662`", "208.16116015608736`", 
     "209.0757885932562`", "209.99783542556415`", "210.86367400683375`", 
     "211.60903503000065`", "212.50776764150928`", "213.39580548288436`", 
     "214.146695156243`", "214.65961760784967`", "250.7447278473759`", 
     "251.90229846318377`", "252.92260076054706`", "253.85643716587896`", 
     "254.8373655892091`", "255.87664693698142`", "256.9246266611394`", 
     "257.8145053100055`", "258.71902919452975`", "259.62960435978965`", 
     "260.37825438338024`", "261.345873117022`", "262.14682268778716`", 
     "262.8833973433988`", "263.58156760165394`", "264.3678014962677`", 
     "301.03898834620054`", "302.11770496144067`", "303.18255835543346`", 
     "304.0728462743775`", "304.96509718642784`", "305.9630300481953`", 
     "306.99879102013284`", "307.99073153804716`", "308.77062849793504`", 
     "309.74773294558344`", "310.51863731451243`", "311.25748804136197`", 
     "312.1015554554749`", "312.75614503529033`", "313.61278020626094`", 
     "314.26827188459123`", "351.583209138163`", "352.4907225387032`", 
     "353.53837174603325`", "354.60502114913766`", "355.47666799567116`", 
     "356.49747254765214`", "357.40025937846605`", "358.2818230842778`", 
     "359.2498393602292`", "360.1241137820782`", "360.83082784226843`", 
     "361.6750028516624`", "362.4771248556672`", "363.3467447537779`", 
     "363.9586139234996`", "364.73191598011704`", "402.5633131466791`", 
     "403.6434220495183`", "404.5579007953138`", "405.4834957377102`", 
     "406.49371531469814`", "407.3433458259535`", "408.4108431514921`", 
     "409.1135982982271`", "410.1784725512977`", "411.0452149311426`", 
     "411.92869770168426`", "412.5735255887339`", "413.50809434773925`", 
     "414.1023252210096`", "414.8876849609577`", "415.4575965084714`", 
     "453.87709088068203`", "454.8579901109222`", "455.8605871262129`", 
     "456.8143822370169`", "457.6972368332261`", "458.65579832510707`", 
     "459.73872081726927`", "460.6310256460997`", "461.52268916549`", 
     "462.31800541256985`", "463.134532467518`", "463.8812785598293`", 
     "464.66554345092715`", "465.35229788946316`", "466.04601684078045`", 
     "466.7986668322856`", "505.7275536341801`", "506.63298720397256`", 
     "507.76039160417093`", "508.47737312754447`", "509.5113160810278`", 
     "510.4697298451496`", "511.3065328677971`", "512.211908588985`", 
     "512.9591880222813`", "513.7818553822425`", "514.7373188418259`", 
     "515.5155514671468`", "516.404355731829`", "517.1184164340067`", 
     "517.8166163028882`", "518.5103598624536`", "558.0280227826872`", 
     "558.8187303997656`", "559.9021841526844`", "560.8535939952312`", 
     "561.6897188048645`", "562.6979550242089`", "563.4385413437996`", 
     "564.6101166218616`", "565.3608892344561`", "566.2143632269559`", 
     "566.9882008461213`", "567.6748200596741`", "568.5474715361017`", 
     "569.4369455138433`", "569.9262486959208`", "570.4971867675391`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "verify", " ", "distortion", " ", "for", " ", "the", " ", "above", " ", 
    RowBox[{"points", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"pointsDistortedLeft", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"undistorted2distorted", "[", 
       RowBox[{"#", ",", "Aleft", ",", "kleft"}], "]"}], "&"}], "/@", 
     "pointsUndistortedLeft"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.433595535920308*^9, 3.433595581515986*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"pointsLeft", "\[LeftDoubleBracket]", 
      RowBox[{"All", ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}]}], "\[RightDoubleBracket]"}], "]"}], 
    ",", 
    RowBox[{"Transpose", "[", "pointsDistortedLeft", "]"}]}], "]"}], "//", 
  "TableForm"}]], "Input"],

Cell[BoxData[
 TagBox[GridBox[{
    {"64.7556`", "109.049`", "153.886`", "199.612`", "246.154`", "293.31`", 
     "340.937`", "388.506`", "436.082`", "483.635`", "530.441`", "576.727`", 
     "621.935`", "666.35`", "709.773`", "752.106`", "60.6705`", "105.065`", 
     "150.378`", "196.65`", "243.675`", "291.213`", "339.564`", "387.71`", 
     "436.14`", "483.94`", "531.558`", "578.02`", "623.985`", "668.519`", 
     "712.197`", "754.793`", "56.605`", "101.228`", "146.859`", "193.627`", 
     "241.101`", "289.367`", "338.18`", "386.966`", "435.818`", "484.193`", 
     "532.021`", "579.49`", "625.54`", "670.604`", "714.443`", "757.524`", 
     "52.962`", "97.9288`", "143.951`", "190.848`", "238.932`", "287.493`", 
     "336.843`", "386.067`", "435.458`", "484.194`", "532.722`", "580.198`", 
     "626.771`", "672.198`", "716.453`", "759.615`", "49.5184`", "94.854`", 
     "140.908`", "188.597`", "236.87`", "285.883`", "335.422`", "385.187`", 
     "434.744`", "484.143`", "532.981`", "580.954`", "627.769`", "673.641`", 
     "718.029`", "761.317`", "46.88`", "92.1894`", "138.701`", "186.274`", 
     "234.889`", "284.213`", "334.249`", "384.193`", "434.287`", "483.995`", 
     "533.19`", "581.203`", "628.363`", "674.235`", "719.102`", "762.373`", 
     "44.2721`", "90.1057`", "136.675`", "184.629`", "233.194`", "282.892`", 
     "332.967`", "383.296`", "433.522`", "483.559`", "532.874`", "581.257`", 
     "628.466`", "674.734`", "719.568`", "763.156`", "42.5378`", "88.1187`", 
     "135.025`", "182.871`", "231.968`", "281.541`", "332.053`", "382.222`", 
     "432.799`", "482.706`", "532.312`", "580.829`", "628.219`", "674.405`", 
     "719.657`", "763.335`", "40.8929`", "86.9117`", "133.814`", "182.034`", 
     "230.805`", "280.621`", "330.792`", "381.363`", "431.866`", "482.028`", 
     "531.446`", "580.097`", "627.497`", "674.046`", "718.958`", "762.98`", 
     "40.2917`", "85.9344`", "133.042`", "180.961`", "229.992`", "279.565`", 
     "330.065`", "380.264`", "430.819`", "480.694`", "530.371`", "578.764`", 
     "626.368`", "672.803`", "717.972`", "762.106`", "39.6959`", "85.7506`", 
     "132.484`", "180.598`", "229.321`", "278.976`", "328.959`", "379.42`", 
     "429.686`", "479.642`", "528.949`", "577.478`", "624.686`", "671.425`", 
     "716.391`", "760.607`", "39.884`", "85.5969`", "132.558`", "180.231`", 
     "229.054`", "278.34`", "328.369`", "378.342`", "428.502`", "478.071`", 
     "527.307`", "575.681`", "622.918`", "669.373`", "714.694`", "758.767`"},
    {"23.4274`", "22.3266`", "21.3438`", "20.6227`", "20.1058`", "20.2646`", 
     "20.6334`", "21.2631`", "22.7136`", "24.2786`", "26.1697`", "28.5769`", 
     "31.0793`", "33.8906`", "36.9427`", "40.1268`", "67.2114`", "66.3889`", 
     "65.5267`", "65.0865`", "64.7856`", "64.8416`", "65.2562`", "66.2618`", 
     "67.2968`", "68.9507`", "70.6883`", "72.9268`", "75.1432`", "77.8272`", 
     "80.7508`", "83.4019`", "112.178`", "111.598`", "111.076`", "110.784`", 
     "110.807`", "110.885`", "111.51`", "112.304`", "113.521`", "115.015`", 
     "116.761`", "118.563`", "120.691`", "123.052`", "125.359`", "128.005`", 
     "158.094`", "157.901`", "157.738`", "157.733`", "157.92`", "158.335`", 
     "158.98`", "159.789`", "160.837`", "162.063`", "163.624`", "165.271`", 
     "167.118`", "169.085`", "171.112`", "172.97`", "204.852`", "205.119`", 
     "205.353`", "205.715`", "206.116`", "206.767`", "207.554`", "208.4`", 
     "209.421`", "210.601`", "211.865`", "213.134`", "214.654`", "216.245`", 
     "217.752`", "219.06`", "252.457`", "253.16`", "253.792`", "254.408`", 
     "255.143`", "256.012`", "256.965`", "257.833`", "258.783`", "259.8`", 
     "260.71`", "261.879`", "262.918`", "263.917`", "264.893`", "265.95`", 
     "300.726`", "301.85`", "302.971`", "303.925`", "304.876`", "305.922`", 
     "306.989`", "307.989`", "308.748`", "309.67`", "310.35`", "310.961`", 
     "311.638`", "312.094`", "312.714`", "313.116`", "349.151`", "350.608`", 
     "352.161`", "353.67`", "354.909`", "356.196`", "357.257`", "358.175`", 
     "359.052`", "359.707`", "360.067`", "360.443`", "360.668`", "360.863`", 
     "360.731`", "360.71`", "397.674`", "399.791`", "401.654`", "403.405`", 
     "405.075`", "406.409`", "407.753`", "408.522`", "409.423`", "409.904`", 
     "410.185`", "410.03`", "409.979`", "409.443`", "408.987`", "408.253`", 
     "446.`", "448.462`", "450.825`", "452.951`", "454.785`", "456.425`", 
     "457.899`", "458.877`", "459.538`", "459.794`", "459.763`", "459.395`", 
     "458.813`", "457.939`", "456.93`", "455.893`", "494.099`", "496.903`", 
     "499.735`", "501.964`", "504.191`", "506.016`", "507.353`", "508.364`", 
     "508.823`", "508.957`", "508.839`", "508.207`", "507.39`", "506.146`", 
     "504.749`", "503.256`", "541.773`", "544.776`", "547.876`", "550.578`", 
     "552.844`", "554.865`", "556.204`", "557.474`", "557.88`", "557.917`", 
     "557.434`", "556.472`", "555.346`", "553.957`", "552.038`", "550.147`"},
    {"64.7556`", "109.04899999999994`", "153.886`", "199.61199999999994`", 
     "246.15400000000002`", "293.31`", "340.937`", "388.506`", "436.082`", 
     "483.635`", "530.441`", "576.727`", "621.935`", "666.3500000000001`", 
     "709.773`", "752.106`", "60.67049999999993`", "105.06499999999997`", 
     "150.37799999999996`", "196.64999999999998`", "243.675`", "291.213`", 
     "339.564`", "387.71`", "436.14`", "483.94`", "531.558`", "578.02`", 
     "623.985`", "668.519`", "712.197`", "754.793`", "56.60500000000007`", 
     "101.22800000000002`", "146.859`", "193.62700000000004`", 
     "241.10099999999997`", "289.367`", "338.18`", "386.966`", "435.818`", 
     "484.193`", "532.021`", "579.49`", "625.54`", "670.604`", "714.443`", 
     "757.5240000000001`", "52.96200000000001`", "97.92880000000007`", 
     "143.95099999999996`", "190.84800000000004`", "238.93199999999996`", 
     "287.493`", "336.8430000000028`", "386.06700000000023`", 
     "435.45799999999855`", "484.194`", "532.722`", "580.1979999999999`", 
     "626.771`", "672.198`", "716.453`", "759.6150000000001`", 
     "49.518400000000014`", "94.85399999999996`", "140.90799999999996`", 
     "188.59699999999998`", "236.86999999999998`", "285.88300000000135`", 
     "335.422`", "385.187`", "434.744`", "484.14299999999884`", "532.981`", 
     "580.954`", "627.769`", "673.641`", "718.029`", "761.3170000000001`", 
     "46.87999999999994`", "92.18939999999994`", "138.701`", "186.274`", 
     "234.88900000000984`", "284.2130000000001`", "334.249`", "384.193`", 
     "434.28700000000003`", "483.9949999999999`", "533.1900000000002`", 
     "581.203`", "628.363`", "674.235`", "719.1020000000001`", "762.373`", 
     "44.27210000000007`", "90.10569999999997`", "136.67499999999998`", 
     "184.629`", "233.1940000000045`", "282.892`", "332.967`", "383.296`", 
     "433.52200000000005`", "483.5589999999998`", "532.874`", "581.257`", 
     "628.466`", "674.734`", "719.568`", "763.156`", "42.53779999999998`", 
     "88.11869999999995`", "135.02499999999998`", "182.871`", 
     "231.96800000001082`", "281.54100000000005`", "332.053`", "382.222`", 
     "432.799`", "482.70599999999774`", "532.312`", "580.829`", "628.219`", 
     "674.405`", "719.657`", "763.335`", "40.89290000000004`", 
     "86.91169999999997`", "133.814`", "182.03399999999993`", "230.805`", 
     "280.6210000000023`", "330.79200000000003`", "381.3629999999999`", 
     "431.86599999999817`", "482.028`", "531.4460000000001`", "580.097`", 
     "627.497`", "674.046`", "718.958`", "762.9800000000001`", 
     "40.29169999999998`", "85.93439999999997`", "133.042`", 
     "180.96100000000004`", "229.992`", "279.565`", "330.065`", "380.264`", 
     "430.819`", "480.694`", "530.371`", "578.7640000000001`", "626.368`", 
     "672.8029999999999`", "717.972`", "762.1060000000001`", 
     "39.69589999999993`", "85.75059999999996`", "132.48399999999998`", 
     "180.59800000000004`", "229.321`", "278.97599999999994`", "328.959`", 
     "379.42`", "429.686`", "479.642`", "528.949`", "577.478`", 
     "624.6859999999999`", "671.425`", "716.391`", "760.607`", "39.884`", 
     "85.59690000000005`", "132.558`", "180.23099999999997`", "229.054`", 
     "278.34`", "328.369`", "378.342`", "428.502`", "478.071`", "527.307`", 
     "575.681`", "622.918`", "669.373`", "714.694`", "758.7669999999999`"},
    {"23.427400000000002`", "22.326599999999974`", "21.343799999999966`", 
     "20.622699999999952`", "20.105799999999977`", "20.264600000000048`", 
     "20.633400000000005`", "21.26309999999999`", "22.713599999999953`", 
     "24.27859999999993`", "26.169700000000056`", "28.576899999999995`", 
     "31.079299999999925`", "33.89060000000002`", "36.94270000000009`", 
     "40.126800000000024`", "67.21140000000003`", "66.38890000000005`", 
     "65.52670000000002`", "65.08650000000002`", "64.78559999999995`", 
     "64.84160000000001`", "65.25619999999998`", "66.26180000000001`", 
     "67.2968`", "68.95069999999993`", "70.68829999999998`", "72.9268`", 
     "75.1432`", "77.82719999999999`", "80.75079999999997`", 
     "83.40190000000004`", "112.17799999999998`", "111.59800000000001`", 
     "111.07599999999998`", "110.78400000000003`", "110.80699999999997`", 
     "110.88499999999999`", "111.50999999999995`", "112.304`", 
     "113.52100000000004`", "115.01499999999997`", "116.76100000000002`", 
     "118.56300000000003`", "120.69100000000006`", "123.05200000000002`", 
     "125.35899999999998`", "128.005`", "158.09400000000002`", "157.901`", 
     "157.738`", "157.73299999999998`", "157.91999999999996`", "158.335`", 
     "158.98000000000636`", "159.7890000000024`", "160.83700000000496`", 
     "162.063`", "163.624`", "165.271`", "167.118`", "169.085`", 
     "171.11199999999997`", "172.97`", "204.852`", "205.119`", 
     "205.35299999999998`", "205.71499999999997`", "206.116`", 
     "206.76700000000116`", "207.55400000000006`", "208.4`", "209.421`", 
     "210.60100000000105`", "211.865`", "213.134`", "214.654`", "216.245`", 
     "217.752`", "219.06`", "252.457`", "253.16`", "253.792`", "254.408`", 
     "255.1430000000026`", "256.012`", "256.965`", "257.833`", "258.783`", 
     "259.80000000000007`", "260.71`", "261.879`", "262.918`", "263.917`", 
     "264.893`", "265.95`", "300.726`", "301.85`", "302.971`", "303.925`", 
     "304.8759999999996`", "305.922`", "306.989`", "307.989`", "308.748`", 
     "309.67`", "310.35`", "310.961`", "311.638`", "312.094`", "312.714`", 
     "313.116`", "349.151`", "350.60799999999995`", "352.161`", "353.67`", 
     "354.90899999999493`", "356.19599999999997`", "357.257`", "358.175`", 
     "359.052`", "359.70699999999874`", "360.067`", "360.443`", 
     "360.66800000000006`", "360.863`", "360.731`", "360.71`", 
     "397.6739999999999`", "399.791`", "401.654`", "403.405`", 
     "405.07499999999993`", "406.40899999999635`", "407.7529999999996`", 
     "408.5219999999996`", "409.42299999999733`", "409.904`", "410.185`", 
     "410.03`", "409.979`", "409.443`", "408.987`", "408.253`", "446.`", 
     "448.462`", "450.825`", "452.951`", "454.785`", "456.425`", "457.899`", 
     "458.877`", "459.538`", "459.794`", "459.763`", "459.395`", "458.813`", 
     "457.939`", "456.93`", "455.893`", "494.09900000000005`", 
     "496.9030000000001`", "499.735`", "501.96399999999994`", "504.191`", 
     "506.0160000000001`", "507.353`", "508.364`", "508.82300000000004`", 
     "508.957`", "508.83900000000006`", "508.207`", "507.39`", 
     "506.1460000000001`", "504.749`", "503.2559999999999`", "541.773`", 
     "544.776`", "547.8760000000001`", "550.578`", "552.844`", "554.865`", 
     "556.204`", "557.4739999999999`", "557.8800000000001`", "557.917`", 
     "557.434`", "556.472`", "555.346`", "553.957`", "552.0380000000001`", 
     "550.147`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"draw", " ", "distorted", " ", 
    RowBox[{"vs", ".", " ", "undistorted"}], " ", 
    RowBox[{"points", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Graphics", "[", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", "Red", "}"}], ",", 
     RowBox[{"Point", "/@", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox[
            RowBox[{
            "#1", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
            RowBox[{
            "sizeImageLeft", "\[LeftDoubleBracket]", "1", 
             "\[RightDoubleBracket]"}]], ",", 
           FractionBox[
            RowBox[{
            "#1", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
            RowBox[{
            "sizeImageLeft", "\[LeftDoubleBracket]", "2", 
             "\[RightDoubleBracket]"}]]}], "}"}], "&"}], ")"}], "/@", 
       RowBox[{"pointsLeft", "\[LeftDoubleBracket]", 
        RowBox[{"All", ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "5"}], "}"}]}], "\[RightDoubleBracket]"}]}]}], 
     ",", 
     RowBox[{"{", "Green", "}"}], ",", 
     RowBox[{"Point", "/@", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox[
            RowBox[{
            "#1", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
            RowBox[{
            "sizeImageLeft", "\[LeftDoubleBracket]", "1", 
             "\[RightDoubleBracket]"}]], ",", 
           FractionBox[
            RowBox[{
            "#1", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
            RowBox[{
            "sizeImageLeft", "\[LeftDoubleBracket]", "2", 
             "\[RightDoubleBracket]"}]]}], "}"}], "&"}], ")"}], "/@", 
       "pointsUndistortedLeft"}]}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.433593338843368*^9, 3.433593339665143*^9}, {
  3.433595587950465*^9, 3.43359559839066*^9}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.940232 0.0147151 0.598408 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.008 w
.10187 .03889 Mdot
.15526 .03775 Mdot
.20931 .03674 Mdot
.26443 .03599 Mdot
.32053 .03546 Mdot
.37737 .03562 Mdot
.43478 .036 Mdot
.49212 .03665 Mdot
.54947 .03815 Mdot
.6068 .03976 Mdot
.66322 .04172 Mdot
.71901 .0442 Mdot
.77351 .04678 Mdot
.82705 .04968 Mdot
.87939 .05283 Mdot
.93042 .05612 Mdot
.09694 .08406 Mdot
.15046 .08321 Mdot
.20508 .08232 Mdot
.26086 .08187 Mdot
.31754 .08156 Mdot
.37485 .08161 Mdot
.43313 .08204 Mdot
.49117 .08308 Mdot
.54954 .08415 Mdot
.60716 .08585 Mdot
.66456 .08765 Mdot
.72057 .08996 Mdot
.77598 .09224 Mdot
.82966 .09501 Mdot
.88231 .09803 Mdot
.93366 .10076 Mdot
.09204 .13045 Mdot
.14583 .12986 Mdot
.20084 .12932 Mdot
.25721 .12902 Mdot
.31444 .12904 Mdot
.37262 .12912 Mdot
.43146 .12976 Mdot
.49027 .13058 Mdot
.54916 .13184 Mdot
.60747 .13338 Mdot
.66512 .13518 Mdot
.72234 .13704 Mdot
.77785 .13924 Mdot
.83217 .14167 Mdot
.88502 .14405 Mdot
.93695 .14678 Mdot
.08765 .17783 Mdot
.14186 .17763 Mdot
.19733 .17746 Mdot
.25386 .17745 Mdot
.31182 .17765 Mdot
.37036 .17808 Mdot
.42985 .17874 Mdot
.48918 .17958 Mdot
.54872 .18066 Mdot
.60747 .18192 Mdot
.66597 .18353 Mdot
.7232 .18523 Mdot
.77934 .18714 Mdot
.83409 .18917 Mdot
.88744 .19126 Mdot
.93947 .19317 Mdot
.0835 .22607 Mdot
.13815 .22634 Mdot
.19366 .22659 Mdot
.25115 .22696 Mdot
.30934 .22737 Mdot
.36842 .22804 Mdot
.42814 .22886 Mdot
.48812 .22973 Mdot
.54786 .23078 Mdot
.60741 .232 Mdot
.66628 .2333 Mdot
.72411 .23461 Mdot
.78054 .23618 Mdot
.83583 .23782 Mdot
.88934 .23938 Mdot
.94152 .24073 Mdot
.08032 .27518 Mdot
.13494 .27591 Mdot
.191 .27656 Mdot
.24835 .2772 Mdot
.30695 .27796 Mdot
.36641 .27885 Mdot
.42672 .27984 Mdot
.48693 .28073 Mdot
.54731 .28171 Mdot
.60723 .28276 Mdot
.66653 .2837 Mdot
.72441 .28491 Mdot
.78125 .28598 Mdot
.83655 .28701 Mdot
.89063 .28802 Mdot
.94279 .28911 Mdot
.07718 .32499 Mdot
.13243 .32615 Mdot
.18856 .3273 Mdot
.24637 .32829 Mdot
.30491 .32927 Mdot
.36481 .33035 Mdot
.42518 .33145 Mdot
.48584 .33248 Mdot
.54639 .33326 Mdot
.6067 .33421 Mdot
.66615 .33492 Mdot
.72447 .33555 Mdot
.78138 .33624 Mdot
.83715 .33671 Mdot
.8912 .33735 Mdot
.94374 .33777 Mdot
.07509 .37495 Mdot
.13003 .37645 Mdot
.18657 .37805 Mdot
.24425 .37961 Mdot
.30343 .38089 Mdot
.36319 .38222 Mdot
.42407 .38331 Mdot
.48455 .38426 Mdot
.54552 .38516 Mdot
.60568 .38584 Mdot
.66547 .38621 Mdot
.72396 .3866 Mdot
.78108 .38683 Mdot
.83675 .38703 Mdot
.8913 .3869 Mdot
.94395 .38687 Mdot
.0731 .42501 Mdot
.12858 .42719 Mdot
.18511 .42912 Mdot
.24324 .43092 Mdot
.30203 .43265 Mdot
.36208 .43402 Mdot
.42255 .43541 Mdot
.48351 .4362 Mdot
.54439 .43713 Mdot
.60486 .43763 Mdot
.66443 .43792 Mdot
.72307 .43776 Mdot
.78021 .43771 Mdot
.83632 .43715 Mdot
.89046 .43668 Mdot
.94353 .43593 Mdot
.07238 .47487 Mdot
.1274 .47741 Mdot
.18418 .47985 Mdot
.24194 .48204 Mdot
.30105 .48393 Mdot
.3608 .48563 Mdot
.42168 .48715 Mdot
.48219 .48816 Mdot
.54313 .48884 Mdot
.60325 .4891 Mdot
.66313 .48907 Mdot
.72147 .48869 Mdot
.77885 .48809 Mdot
.83482 .48719 Mdot
.88927 .48615 Mdot
.94247 .48508 Mdot
.07166 .5245 Mdot
.12718 .52739 Mdot
.18351 .53031 Mdot
.24151 .53261 Mdot
.30024 .53491 Mdot
.36009 .53679 Mdot
.42035 .53817 Mdot
.48117 .53921 Mdot
.54176 .53969 Mdot
.60198 .53983 Mdot
.66142 .5397 Mdot
.71992 .53905 Mdot
.77682 .53821 Mdot
.83316 .53693 Mdot
.88737 .53548 Mdot
.94067 .53394 Mdot
.07189 .57368 Mdot
.12699 .57678 Mdot
.1836 .57998 Mdot
.24106 .58277 Mdot
.29992 .58511 Mdot
.35933 .58719 Mdot
.41963 .58857 Mdot
.47987 .58988 Mdot
.54034 .5903 Mdot
.60009 .59034 Mdot
.65944 .58984 Mdot
.71775 .58885 Mdot
.77469 .58769 Mdot
.83069 .58625 Mdot
.88532 .58427 Mdot
.93845 .58232 Mdot
0 1 0 r
.07699 .02106 Mdot
.13665 .02234 Mdot
.19577 .02349 Mdot
.2549 .02459 Mdot
.3141 .02553 Mdot
.37332 .02678 Mdot
.43263 .02779 Mdot
.49163 .0286 Mdot
.55071 .02984 Mdot
.61012 .03072 Mdot
.6692 .03153 Mdot
.72849 .03252 Mdot
.78745 .03328 Mdot
.84658 .03411 Mdot
.90563 .03506 Mdot
.9644 .03609 Mdot
.07451 .07072 Mdot
.13414 .07203 Mdot
.19361 .07305 Mdot
.2531 .07424 Mdot
.3125 .07523 Mdot
.37174 .07623 Mdot
.43145 .0772 Mdot
.49067 .0784 Mdot
.55031 .0792 Mdot
.60954 .08028 Mdot
.6692 .08105 Mdot
.72832 .08205 Mdot
.78794 .08271 Mdot
.84698 .08367 Mdot
.90623 .08474 Mdot
.96538 .08543 Mdot
.07171 .12085 Mdot
.1315 .12207 Mdot
.19117 .12314 Mdot
.251 .12421 Mdot
.31062 .12532 Mdot
.37037 .12618 Mdot
.43023 .12728 Mdot
.48982 .12821 Mdot
.54955 .12926 Mdot
.60907 .13027 Mdot
.66861 .13124 Mdot
.72866 .13198 Mdot
.78811 .13284 Mdot
.84764 .13377 Mdot
.907 .13451 Mdot
.96679 .13555 Mdot
.06904 .1713 Mdot
.12918 .17251 Mdot
.18918 .17359 Mdot
.24893 .17464 Mdot
.30903 .17567 Mdot
.36884 .17669 Mdot
.42903 .1777 Mdot
.48881 .17862 Mdot
.54886 .17954 Mdot
.6085 .18039 Mdot
.6686 .18137 Mdot
.72839 .18223 Mdot
.78827 .18312 Mdot
.84811 .18401 Mdot
.90794 .18486 Mdot
.96784 .18548 Mdot
.0661 .22209 Mdot
.12666 .22333 Mdot
.18659 .22441 Mdot
.2472 .22549 Mdot
.30734 .22646 Mdot
.36749 .22752 Mdot
.42767 .22856 Mdot
.48786 .22948 Mdot
.54786 .23043 Mdot
.60808 .23138 Mdot
.66834 .23227 Mdot
.72857 .23304 Mdot
.78861 .23397 Mdot
.84892 .23488 Mdot
.90887 .23566 Mdot
.96894 .23619 Mdot
.06363 .27342 Mdot
.12414 .27461 Mdot
.18462 .27567 Mdot
.245 .27663 Mdot
.30547 .27764 Mdot
.36588 .27871 Mdot
.42654 .27979 Mdot
.48681 .28071 Mdot
.54732 .28165 Mdot
.60779 .28258 Mdot
.66837 .28336 Mdot
.72854 .28436 Mdot
.78894 .28518 Mdot
.84919 .28594 Mdot
.90976 .28666 Mdot
.96982 .28747 Mdot
.06053 .32531 Mdot
.12179 .32642 Mdot
.18236 .32752 Mdot
.24324 .32844 Mdot
.30365 .32936 Mdot
.3645 .33039 Mdot
.42519 .33146 Mdot
.4859 .33248 Mdot
.54655 .33329 Mdot
.60739 .33429 Mdot
.6681 .33509 Mdot
.72872 .33585 Mdot
.78919 .33672 Mdot
.84998 .3374 Mdot
.91053 .33828 Mdot
.97105 .33896 Mdot
.05791 .37746 Mdot
.11893 .37839 Mdot
.18005 .37947 Mdot
.2409 .38057 Mdot
.30208 .38147 Mdot
.36288 .38253 Mdot
.42419 .38346 Mdot
.4848 .38437 Mdot
.54597 .38537 Mdot
.60674 .38627 Mdot
.6679 .387 Mdot
.72878 .38787 Mdot
.78956 .3887 Mdot
.85032 .38959 Mdot
.9115 .39023 Mdot
.9722 .39102 Mdot
.0547 .43006 Mdot
.11646 .43117 Mdot
.17776 .43211 Mdot
.23927 .43307 Mdot
.30024 .43411 Mdot
.36156 .43499 Mdot
.42267 .43609 Mdot
.48397 .43681 Mdot
.54526 .43791 Mdot
.60655 .43881 Mdot
.66768 .43972 Mdot
.72891 .44038 Mdot
.78988 .44135 Mdot
.85126 .44196 Mdot
.9121 .44277 Mdot
.97335 .44336 Mdot
.05221 .483 Mdot
.11367 .48401 Mdot
.17548 .48504 Mdot
.2369 .48603 Mdot
.29851 .48694 Mdot
.35984 .48793 Mdot
.42168 .48905 Mdot
.48287 .48997 Mdot
.54455 .49089 Mdot
.6058 .49171 Mdot
.66756 .49255 Mdot
.72874 .49332 Mdot
.79022 .49413 Mdot
.85166 .49484 Mdot
.91299 .49555 Mdot
.97447 .49633 Mdot
.04909 .53649 Mdot
.11134 .53743 Mdot
.17296 .53859 Mdot
.235 .53933 Mdot
.29661 .5404 Mdot
.35847 .54139 Mdot
.42012 .54225 Mdot
.48207 .54318 Mdot
.54384 .54395 Mdot
.60562 .5448 Mdot
.66732 .54579 Mdot
.72905 .54659 Mdot
.79035 .54751 Mdot
.85245 .54825 Mdot
.91368 .54897 Mdot
.97533 .54968 Mdot
.0465 .59045 Mdot
.10853 .59127 Mdot
.17081 .59239 Mdot
.2327 .59337 Mdot
.29492 .59423 Mdot
.35684 .59527 Mdot
.41909 .59604 Mdot
.48099 .59724 Mdot
.54317 .59802 Mdot
.605 .5989 Mdot
.6671 .5997 Mdot
.72908 .60041 Mdot
.79079 .60131 Mdot
.85282 .60223 Mdot
.91471 .60273 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{961.375, 594.188},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],
 ImageRangeCache->{{{0, 960.375}, {593.188, 0}} -> {-0.0256395, -0.0245904, \
0.00110811, 0.00174109}}]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowToolbars->"RulerBar",
WindowSize->{1016, 690},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
FrontEndVersion->"6.0 for Linux x86 (32-bit) (June 19, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 1110, 20, 147, "Text"],
Cell[CellGroupData[{
Cell[1703, 45, 171, 3, 71, "Section",
 InitializationCell->True],
Cell[1877, 50, 1288, 27, 216, "Input"],
Cell[3168, 79, 4191, 96, 437, "Input"],
Cell[7362, 177, 22428, 482, 1525, "Input"],
Cell[29793, 661, 13580, 321, 840, "Input"],
Cell[43376, 984, 9063, 182, 454, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52476, 1171, 194, 3, 71, "Section",
 InitializationCell->True],
Cell[52673, 1176, 104, 3, 28, "Input"],
Cell[52780, 1181, 780, 22, 28, "Input"],
Cell[53563, 1205, 963, 29, 104, "Input"],
Cell[54529, 1236, 274, 8, 28, "Input"],
Cell[54806, 1246, 505, 15, 46, "Input"],
Cell[55314, 1263, 1098, 33, 80, "Input"],
Cell[56415, 1298, 341, 10, 44, "Input"],
Cell[56759, 1310, 1253, 37, 80, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58049, 1352, 92, 1, 71, "Section"],
Cell[CellGroupData[{
Cell[58166, 1357, 661, 18, 46, "Input"],
Cell[CellGroupData[{
Cell[58852, 1379, 300, 8, 21, "Print"],
Cell[59155, 1389, 312, 7, 21, "Print"],
Cell[59470, 1398, 314, 7, 21, "Print"]
}, Open  ]]
}, Open  ]],
Cell[59811, 1409, 787, 18, 63, "Input"],
Cell[60601, 1429, 629, 16, 46, "Input"],
Cell[CellGroupData[{
Cell[61255, 1449, 382, 11, 28, "Input"],
Cell[61640, 1462, 14791, 206, 80, "Output"]
}, Open  ]],
Cell[76446, 1671, 514, 13, 46, "Input"],
Cell[CellGroupData[{
Cell[76985, 1688, 380, 11, 28, "Input"],
Cell[77368, 1701, 12238, 172, 80, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[89643, 1878, 2006, 54, 109, "Input"],
Cell[91652, 1934, 13432, 518, 603, 7836, 423, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
