% function [undistorted,n_it] = f_undistort_features_iterations(distorted,A,k1,k2)
% 
% DESCRIPTION: undistorts a vector of projections using A,k1,k2 by plain iterations
% SOURCE: Klaus Strobl
% 
function [undistorted,n_it] = f_undistort_features_iterations(distorted,A,k1,k2)

% starting out, we temporarily assume the original distorted image
% points as undistorted, distort them and compute the residuals,
% which shall be subtracted from the temporal undistorted in order
% their distorted to equal the original distorted image points.

und_tmp = distorted;

% inits
distortion_error = [1;1]; i=1; optim_done=0;

while (~optim_done)

  u = und_tmp(1,:) - A(1,3);
  v = und_tmp(2,:) - A(2,3);
  y = v/A(2,2);
  x2 = ( (u-A(1,2)*y) / A(1,1) ).^2;
  y2 = y.^2;
  dis_tmp = und_tmp + [k1*u.*(x2+y2) + k2*u.*(x2+y2).^2; ...
                       k1*v.*(x2+y2) + k2*v.*(x2+y2).^2];
  distortion_error = dis_tmp - distorted;  max_distortion_error_square = max(sum(distortion_error.^2));
  und_tmp = und_tmp - distortion_error;
  
  if (max_distortion_error_square<1e-4) % dis_error < 1e-2 pixels
    optim_done=1;
  else
    i=i+1; % 4 iterations should suffice
  end
  
end

%sqrt(max_distortion_error_square)
n_it=i;
undistorted = und_tmp;